/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.miniserv.server;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.miniserv.server.ClientManager;
import net.montoyo.wd.miniserv.server.ServerClient;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.Util;

public class Server
implements Runnable {
    private static Server instance;
    private ServerSocketChannel server;
    private Selector selector;
    private int port = 25566;
    private final ArrayList<ServerClient> clientList = new ArrayList();
    private final HashMap<SocketChannel, ServerClient> clientMap = new HashMap();
    private final ByteBuffer readBuffer = ByteBuffer.allocateDirect(8192);
    private final ClientManager clientMgr = new ClientManager();
    private File directory;
    private volatile boolean running;
    private volatile Thread thread;

    public static Server getInstance() {
        if (instance == null) {
            instance = new Server();
        }
        return instance;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int p) {
        this.port = p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.thread = new Thread(this);
        this.thread.setName("MiniServServer");
        this.thread.setDaemon(true);
        try {
            this.server = ServerSocketChannel.open();
            this.server.bind(new InetSocketAddress(this.port));
            this.server.configureBlocking(false);
        }
        catch (Throwable t) {
            t.printStackTrace();
            Util.silentClose(this.server);
            this.server = null;
            return;
        }
        try {
            this.selector = Selector.open();
            this.server.register(this.selector, 16);
        }
        catch (Throwable t) {
            t.printStackTrace();
            Util.silentClose(this.selector);
            Util.silentClose(this.server);
            this.selector = null;
            this.server = null;
            return;
        }
        Server server = this;
        synchronized (server) {
            this.running = true;
        }
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer() throws IOException {
        if (this.getRunning()) {
            Thread thread = this.thread;
            Server server = this;
            synchronized (server) {
                this.running = false;
                this.selector.wakeup();
                this.server.close();
            }
            while (thread.isAlive()) {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            Log.info("Miniserv server stopped", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getRunning() {
        boolean ret;
        Server server = this;
        synchronized (server) {
            ret = this.running;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.getRunning()) {
            try {
                this.loopUnsafe();
            }
            catch (Throwable t) {
                Log.errorEx("Miniserv Server crashed", t, new Object[0]);
                break;
            }
        }
        Server server = this;
        synchronized (server) {
            this.running = false;
        }
        for (ServerClient cli : this.clientList) {
            Util.silentClose(cli.getChannel());
        }
        this.clientList.clear();
        this.clientMap.clear();
        Util.silentClose(this.selector);
        Util.silentClose(this.server);
        this.selector = null;
        this.server = null;
        this.thread = null;
    }

    private void loopUnsafe() throws Throwable {
        this.selector.select(1000L);
        for (SelectionKey key : this.selector.selectedKeys()) {
            if (key == null) continue;
            try {
                ServerClient cli;
                if (key.isAcceptable()) {
                    SocketChannel chan;
                    try {
                        chan = this.server.accept();
                    }
                    catch (Throwable t) {
                        Log.warningEx("Could not accept client", t, new Object[0]);
                        chan = null;
                    }
                    if (chan != null) {
                        chan.configureBlocking(false);
                        ServerClient toAdd = new ServerClient(chan, this.selector);
                        this.clientMap.put(chan, toAdd);
                        this.clientList.add(toAdd);
                    }
                }
                if (key.isReadable()) {
                    cli = this.clientMap.get(key.channel());
                    if (cli == null) {
                        Log.warning("Received read info from unknown client", new Object[0]);
                    } else {
                        try {
                            this.readBuffer.clear();
                            int read = cli.getChannel().read(this.readBuffer);
                            if (read < 0) {
                                cli.setShouldRemove();
                            } else if (read > 0) {
                                this.readBuffer.position(0);
                                this.readBuffer.limit(read);
                                cli.readyRead(this.readBuffer);
                            }
                        }
                        catch (Throwable t) {
                            Log.warningEx("Could not read data from client", t, new Object[0]);
                            cli.setShouldRemove();
                        }
                    }
                }
                if (!key.isWritable()) continue;
                cli = this.clientMap.get(key.channel());
                if (cli == null) {
                    Log.warning("Received write info from unknown client", new Object[0]);
                    continue;
                }
                try {
                    cli.readyWrite();
                }
                catch (Throwable t) {
                    Log.warningEx("Could not write data to client", t, new Object[0]);
                    cli.setShouldRemove();
                }
            }
            catch (Throwable err) {}
        }
        long ctime = System.currentTimeMillis();
        for (int i = this.clientList.size() - 1; i >= 0; --i) {
            ServerClient cli = this.clientList.get(i);
            if (cli.shouldRemove()) {
                this.removeClient(cli);
                continue;
            }
            if (!cli.hasTimedOut(ctime)) continue;
            Log.info("Client %s has timed out!", cli.getUUIDString());
            this.removeClient(cli);
        }
    }

    private void removeClient(ServerClient cli) {
        this.clientMap.remove(cli.getChannel());
        this.clientList.remove(cli);
        Util.silentClose(cli.getChannel());
    }

    public ClientManager getClientManager() {
        return this.clientMgr;
    }

    public void setDirectory(File dir) {
        if (!dir.exists() && !dir.mkdir()) {
            Log.warning("Could not create miniserv storage directory %s", dir.getAbsolutePath());
        }
        this.directory = dir;
    }

    public File getDirectory() {
        return this.directory;
    }

    public long getMaxQuota() {
        return WebDisplays.INSTANCE.miniservQuota;
    }
}

